
' enable this line if using a 3 line LCD
' #option LCD_DOGM = DOGM_163

' file imports...
imports LCDDogm                      ' import DOGM LCD library
imports DS1307                       ' import RTC module
Imports OW                           ' one wire, used for search
Imports DS18B20                      ' temperature sensor module
imports SD                           ' secure digital (SD) module

' program variables...
private DS18B20_Available As Boolean = False ' DS18B20 is available flag
private Time As RtcTime                      ' time variable
private Date As RtcDate                      ' date variable

' the event is triggered each time the OW module is asked to
' perform a search - in this example, we are going to be looking 
' for an DS18B20 device, which has a family ID of 0x28 (owDS18B20)...
Sub OnDeviceFound(command As Byte, family As Byte, ByRef romID() As Byte, ByRef abort As Boolean) Handles OW.OnSearch
   If command = owSearchROM And family = DS18B20.Family Then
      DS18B20_Available = True   ' mark as available
      DS18B20.ROMID = romID     ' set the unique ROM id... 
      abort = True              ' no more searching required   
   End If
End Sub

' main program entry point...
sub Main()  
   dim sdAvailable as boolean = SD.Init() = errOK 
   dim canWriteToSD as boolean = true   
   Console.Write("sdAvailable = ", cstr(sdAvailable),13,10)
   
   ' look for attached temperature sensor...
   OW.Search()
   If DS18B20_Available Then DS18B20.SetResolution(Resolution.Is9Bit)
   
   ' clear LCD and set backlight        
   Dogm.Clear  
   Dogm.SetBacklight(160)  
   
   ' set the real time clock, you should only have
   ' to do this once if backup battery is installed... 
   ' SetRTC()   
      
   ' loop forever...
   while true
      
      ' read time and date...
      Time = DS1307.ReadTime()
      Date = DS1307.ReadDate()  
      
      ' display time and date to LCD...
      Dogm.WriteAt(1,1,Str(Time.Hour, 2),":",Str(Time.Minute,2),":",Str(Time.Second,2))
      Dogm.WriteAt(2,1,GetDay(Date.DayOfWeek))
      Dogm.WriteAt(2,5,Str(Date.Day,2))
      Dogm.WriteAt(2,8," ", GetMonth(Date.Month)," 20",Str(Date.Year,2))
                    
      ' key control... 
      dim Key as byte = Keypress
      select Key    
                
         ' key down
         case 2 : 
            Dogm.SetBacklight(Dogm.GetBacklight - 1)
            delayms(10)   
            
         ' key up
         case 4 : 
            Dogm.SetBacklight(Dogm.GetBacklight + 1)
            delayms(10)
            
         ' key right...
         case 3 :     
            Dogm.SetContrast(Dogm.GetContrast + 1)
            delayms(100)
            
         ' key left...
         case 5 :     
            Dogm.SetContrast(Dogm.GetContrast - 1)
            delayms(100)            
      end select   
             
      ' if enter pressed, display light sensor....
      if Key = 1 then
         dim sensor as ushort = Adc.Read(A1)
         Dogm.WriteAt(1,11,"  ", str(sensor,4)) 
      
      ' if enter not selected, display temperature...
      elseif Key = 0 and DS18B20_Available then  
         DS18B20.Convert()
         Dogm.WriteAt(1,11, DS18B20.AsString, &HDF, "C") 
         
         ' write to SD card...  
         if Time.Second > 0 then canWriteToSD = true
         if sdAvailable and canWriteToSD and (Time.Second = 0) then
            canWriteToSD = false
            if not SD.FileExists("log.csv") then
               SD.Create("log.csv")
               SD.Close()
            end if
            if SD.Append("log.csv") = errOK then 
               SD.Write(Str(Date.Day,2), "/")
               SD.Write(Str(Date.Month,2), "/")
               SD.Write(Str(Date.Year,2))
               SD.Write(",")
               SD.Write(Str(Time.Hour, 2),":",Str(Time.Minute,2))
               SD.Write(",")
               SD.Write(DS18B20.AsString)
               SD.Write(13,10)
               SD.Close()
            end if             
         end if 
      end if
   end while
end sub

' return the day of the week as a string value...
Function GetDay(index As Byte) As String
   if (index < 1) or (index > 7) then return "XXX"
   Const days(7) As String = {"MON", "TUE","WED", "THU", "FRI", "SAT", "SUN"}
   return days(index - 1)
End Function

' return month as a string value...
Function GetMonth(index As Byte) As String
   if (index < 1) or (index > 12) then return "XXX"
   Const months(12) As String = {"JAN","FEB","MAR","APR","MAY","JUN","JUL","AUG","SEP","OCT","NOV","DEC"}
   return months(index - 1)
End Function          
       
' set RTC... 
Sub SetRTC()

   ' set the time... 
   With Time, Time.Mode
      .Hour = 10
      .Minute = 22
      .Second = 0
      .Is12Hour = false
      .PM = false
   End With
   DS1307.WriteTime(Time)
                    
   ' set the date...  
   With Date
      .Day = 1
      .DayOfWeek = 1
      .Month = 4
      .Year = 13
   End With
   DS1307.WriteDate(Date)   
   
End Sub

' get keypress...
function Keypress() as byte
   dim voltage as ushort = Adc.Read(A0)
   Keypress = 0 
   select voltage
      case 0     : Keypress = 1  ' select
      case < 200 : Keypress = 2  ' down
      case < 400 : Keypress = 3  ' right
      case < 600 : Keypress = 4  ' up
      case < 800 : Keypress = 5  ' left
   end select
end function
